#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009-2010 Yukikaze
import commands
import datetime
import os
import re
import shutil
import time
import os.path
import traceback

import chdb
import configreader
import status
import ts2x264
import tv2ts
import recdblist
import tv2audio


global Bitrate_SD
global Bitrate_HD
global Bitrate_FHD
global Bitrate_Short
global Bitrate_LowHD
Bitrate_SD = 1250
Bitrate_HD = 3750
Bitrate_LowHD = 2500
Bitrate_FHD = 5000
Bitrate_Short = 1250
def timetv2b25(pout, chtxt, btime, etime, opt):
    """
    poutはタイトル
    """
    bt = datetime.datetime.strptime(btime, "%Y-%m-%d %H:%M:%S")
    et = datetime.datetime.strptime(etime, "%Y-%m-%d %H:%M:%S")
    extt = os.path.splitext(pout)
    tsout = extt[0]
    tnow = datetime.datetime.now()
    wt = bt-tnow
    waitt = wt.seconds
    if waitt>0:
        time.sleep(waitt)
    tnow = datetime.datetime.now()
    dt = et-tnow
    rectime = dt.seconds-5
    rectime = str(rectime)
    tv2ts.tv2b25ts(tsout + ".ts.b25", chdb.chtxtsearch(chtxt)['ch'], rectime)
def b252ts(pout, chtxt, btime, etime, opt):
    """
    poutはタイトル(自動的にtitle.b25 title.tsと名前がつきます。)
    """
    #status.setB25Decoding(status.getB25Decoding() + 1)
    status.changeB25Decoding(1)
    try:
        tv2ts.b252ts(pout + ".ts", chdb.chtxtsearch(chtxt)['ch'], chdb.chtxtsearch(chtxt)['csch'])
        tsout = pout
        aviin = pout + ".ts"
        dualaudio = 0
        pentaaudio = 0
        singleaudiosplit = 0
        if re.search("5", opt):
            pentaaudio = 1
        if re.search("d", opt):
            dualaudio = 1
        if re.search(u"\[二\]", pout):
            dualaudio = 1
        elif re.search(u'（二）', pout):
            dualaudio = 1
        elif re.search(u'\(二\)', pout):
            dualaudio = 1
        elif re.search("b",opt):
            singleaudiosplit = 1
        if dualaudio == 1:
            dualaudio2sep(aviin,"167")
        if pentaaudio == 1:
            pentaaudio2sep(aviin)
        if singleaudiosplit ==1:
            singleaudio2sep(aviin)
    except Exception, inst:
        recdblist.Commonlogex("Error", "b252ts(tv2avi.py)", str(type(inst))+traceback.format_exc(), str(inst))
    status.changeB25Decoding(-1)
def ts2avi(pin, pout, opt):
    status.changeEncoding(1)
    try:
        ts2x264.ts2x264(pin, pout, opt)
    except Exception, inst:
        recdblist.printutf8("error occures in tv2avi.py ts2avi")
        recdblist.printutf8(str(type(inst)))
        recdblist.printutf8(str(inst)+traceback.format_exc())
    status.changeEncoding(-1)
def ts2raw(pin, pout, opt):
    status.changeEncoding(1)
    try:
        ts2x264.ts2x264(pin, pout, opt)
    except Exception, inst:
        recdblist.printutf8("error occures in tv2avi.py ts2raw")
        recdblist.printutf8(str(type(inst)))
        recdblist.printutf8(str(inst)+traceback.format_exc())
    status.changeEncoding(-1)
def dualaudio2sep(pin, delay):
    """
    delay is string
    """
    xvfb = configreader.getpath('xvfb-run')
    bontsdemux = configreader.getpath('bontsdemux')
    wine = configreader.getpath('wine')
    bonpin = "Z:\\" + pin[1:]
    outf = os.path.splitext(pin)[0]
    bonpout = "Z:\\" + outf[1:]
    exe = wine + ' ' + bontsdemux + " -i \"" + bonpin + "\" -delay " + delay + " -nd -sound 1 -o \"" + bonpout + "\" -start -quit"
    recdblist.printutf8(exe)
    exe = xvfb + ' -a ' + exe
    txt=commands.getoutput(exe.encode('utf-8'))
    try:
        recdblist.addCommandLog(pin, u"BonTsDemux 第一音声取り出し", exe, txt)
    except:
        ""
    ffpin = pin.replace(".ts", "")
    ffpin1 = pin.replace("ts", "wav")
    ffpin2 = pin.replace("ts", "m2v")
    ffpout1 = ffpin + "_1.wav"
    ffpout2 = ffpin + "_2.wav"
    ffpout3 = ffpin + ".m2v"
    shutil.move(ffpin1, ffpout1)
    exe = 'wine ' + bontsdemux + " -i \"" + bonpin + "\" -delay " + delay + " -nd -sound 2 -encode Demux\(wav\) -o \"" + bonpout + "\" -start -quit"
    recdblist.printutf8(exe)
    exe = xvfb + ' -a ' + exe
    txt=commands.getoutput(exe.encode('utf-8'))
    try:
        recdblist.addCommandLog(pin, u"BonTsDemux 第二音声取り出し", exe, txt)
    except:
        ""
    #os.system(exe)
    shutil.move(ffpin1, ffpout2)
    shutil.move(ffpin2, ffpout3)
    ffpout21=ffpout1.replace(".wav",".mp3")
    ffpout22=ffpout2.replace(".wav",".mp3")
    useNero=0
    try:
        if configreader.getpath("useNeroAAC")=="1" and os.path.exists(configreader.getpath("NeroAAC")):
            useNero=1
    except:
        useNero=0
    if useNero==1:
        ffpout21=ffpout1.replace(".wav",".aac")
        ffpout22=ffpout2.replace(".wav",".aac")
        tv2audio.wav2aac_nero(ffpout1, ffpout21)
        tv2audio.wav2aac_nero(ffpout2, ffpout22)
    else:
        tv2audio.wav2mp3_lame(ffpout1, ffpout21)
        tv2audio.wav2mp3_lame(ffpout2, ffpout22)
    time.sleep(3)
    os.remove(ffpout1)
    os.remove(ffpout2)
def pentaaudio2sep(pin):
    bontsdemux = configreader.getpath('bontsdemux')
    wine = configreader.getpath('wine')
    xvfb = configreader.getpath('xvfb-run')
    bonpin = "Z:\\" + pin[1:]
    outf = os.path.splitext(pin)[0]
    bonpout = "Z:\\" + outf[1:]
    exe = wine + ' ' + bontsdemux + " -i \"" + bonpin + "\" -delay 167 -nd -sound 3 -o \"" + bonpout + "\" -start -quit"
    exe = xvfb + ' -a ' + exe
    recdblist.printutf8(exe)
    txt=commands.getoutput(exe.encode('utf-8'))
    try:
        recdblist.addCommandLog(pin, u"BonTsDemux5.1ch 第一音声取り出し", exe, txt)
    except:
        ""
    ffpin = pin.replace(".ts", "")
    ffpin1 = pin.replace("ts", "wav")
    ffpin2 = pin.replace("ts", "m2v")
    ffpout1 = ffpin + "_1.wav"
    ffpout2 = ffpin + "_2.aac"
    shutil.move(ffpin1, ffpout1)
    exe = "ffmpeg -i '"+pin+"' -vn -f aac -acodec copy '"+ffpout2+"'"
    recdblist.printutf8(exe)
    txt=commands.getoutput(exe.encode('utf-8'))
    try:
        recdblist.addCommandLog(pin, u"FFmpeg 5.1ch 第二音声(raw AAC)取り出し", exe, txt)
    except:
        ""
    ffpout21=ffpout1.replace(".wav",".mp3")
    useNero=0
    try:
        if configreader.getpath("useNeroAAC")=="1" and os.path.exists(configreader.getpath("NeroAAC")):
            useNero=1
    except:
        useNero=0
    if useNero==1:
        ffpout21=ffpout1.replace(".wav",".aac")
        tv2audio.wav2aac_nero(ffpout1, ffpout21)
    else:
        tv2audio.wav2mp3_lame(ffpout1, ffpout21)
    if not os.path.exists(ffpout21):
        exe = wine + ' ' + bontsdemux + " -i \"" + bonpin + "\" -delay 167 -nd -sound 0 -o \"" + bonpout + "\" -start -quit"
        exe = xvfb + ' -a ' + exe
        recdblist.printutf8(exe)
        txt=commands.getoutput(exe.encode('utf-8'))
        try:
            recdblist.addCommandLog(pin, u"BonTsDemux 修正版第二音声(2chDownmix)取り出し", exe, txt)
        except:
            ""
        shutil.move(ffpin1, ffpout1)
        if useNero==1:
            ffpout21=ffpout1.replace(".wav",".aac")
            tv2audio.wav2aac_nero(ffpout1, ffpout21)
        else:
            tv2audio.wav2mp3_lame(ffpout1, ffpout21)
        time.sleep(3)
    ffpout21=ffpout1.replace(".wav",".aac")
    if os.path.exists(ffpout21):
        if os.path.getsize(ffpout21)>10*1000*1000:
            os.remove(ffpout1)

def singleaudio2sep(pin):
    bontsdemux = configreader.getpath('bontsdemux')
    wine = configreader.getpath('wine')
    xvfb = configreader.getpath('xvfb-run')
    bonpin = "Z:\\" + pin[1:]
    outf = os.path.splitext(pin)[0]
    bonpout = "Z:\\" + outf[1:]
    exe = wine + ' ' + bontsdemux + " -i \"" + bonpin + "\" -delay 167 -nd -sound 0 -o \"" + bonpout + "\" -start -quit"
    exe = xvfb + ' -a ' + exe
    recdblist.printutf8(exe)
    txt=commands.getoutput(exe.encode('utf-8'))
    try:
        recdblist.addCommandLog(pin, u"BonTsDemux 音声(wav化)取り出し", exe, txt)
    except:
        ""
    ffpin = pin.replace(".ts", "")
    ffpin1 = pin.replace("ts", "wav")
    ffpin2 = pin.replace("ts", "m2v")
    ffpout1 = ffpin + "_1.wav"
    ffpout2 = ffpin + "_2.aac"
    shutil.move(ffpin1, ffpout1)
    exe = "ffmpeg -i '"+pin+"' -vn -f aac -acodec copy '"+ffpout2+"'"
    recdblist.printutf8(exe)
    txt=commands.getoutput(exe.encode('utf-8'))
    try:
        recdblist.addCommandLog(pin, u"FFmpeg 音声(raw AAC)取り出し", exe, txt)
    except:
        ""
    ffpout21=ffpout1.replace(".wav",".mp3")
    useNero=0
    try:
        if configreader.getpath("useNeroAAC")=="1" and os.path.exists(configreader.getpath("NeroAAC")):
            useNero=1
    except:
        useNero=0
    if useNero==1:
        ffpout21=ffpout1.replace(".wav",".aac")
        tv2audio.wav2aac_nero(ffpout1, ffpout21)
    else:
        tv2audio.wav2mp3_lame(ffpout1, ffpout21)
    ffpout21=ffpout1.replace(".wav",".aac")
    if os.path.exists(ffpout21):
        if os.path.getsize(ffpout21)>10*1000*1000:
            os.remove(ffpout1)